<?php
/* 
 Copyright (C) 2005-2007 Earl C. Terwilliger
 Email contact: earl@micpc.com

 Name : astdir.php 
 Usage: PHP script to read files in a directory and list them as links
        to selectively edit with astedit.php

    This file is part of The Asterisk WEB/PHP Management Interface.

    These files are free software; you can redistribute them and/or modify
    them under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    These programs are distributed in the hope that they will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with these files (see COPYING); if not, write to the:

         Free Software Foundation, Inc.
         59 Temple Place
         Suite 330
         Boston, MA  02111-1307
         USA
*/

include('header.php');
include('files.php');

if (isset($_POST['path'])) $path = $_POST['path'];
else {
    if (isset($_GET['path'])) $path = $_GET['path'];
    else $path = $ASTCONFIGPATH;
}
if (isset($_POST['directory'])) $directory = $_POST['directory'];
else                            $directory = "";
if ($directory != "") $path = $directory;

if (isset($_GET['edit'])) $edit = $_GET['edit'];
else $edit = "yes";
if (isset($_POST['edit'])) $edit = $_GET['edit'];

echo "<div align=center>";
echo "<H1>Directory of $path</H1>";

$handle = opendir($path) or die("Unable to open $path<br>Make sure it exits with proper authority.");

$numfiles = 0;
$numdirs  = 0;
if (substr($path,-1,1) == '/') $path = substr($path,0,-1);

clearstatcache();

$file_array = Array();

while ($file = readdir($handle))  $file_array[] = $file;
closedir($handle);

sort ($file_array);
reset ($file_array);

echo "<table border=0>";
while (list ($key, $val) = each ($file_array))
{
  if($val =="." || $val == "..") continue;
  echo "<tr>";
  $fname = $path . '/' . $val;
  if(is_dir($fname)) {
    $numdirs += 1;
    echo "<td><a href=astdir.php?path=$fname&edit=$edit>[dir]&nbsp;$val</a></td>";
    echo "<td>&nbsp;</td>";
    echo "<td><a href=astdel.php?path=$fname>Delete</a></td>";
  }
  else {
    $numfiles +=1;
    if (strtolower($edit) == "yes") 
      echo "<td><a href=astedit.php?file=$fname>$val</a></td>";
    else 
      echo "<td><a href=astsend.php?file=$fname>$val</a></td>";
    echo "<td>&nbsp;</td>";
    echo "<td><a href=astdel.php?file=$fname>Delete</a></td>";
  }
  echo "</tr>";
}
echo "</table>";
echo "<br>";
echo $numfiles.' files in this directory';
echo "<br>";
echo $numdirs.' subdirectories in this directory';
echo "</div>";
?>
