#!/bin/env python
import cgi   

# Copyright (C) 2006 Earl C. Terwilliger   earl@micpc.com
#
# Reads MySql table to create HTML output for CDR records

import sys, string, os, time, datetime, MySQLdb

def html_form():
  time_now = datetime.datetime.now()
  current_date = time_now.strftime("%Y-%m-%d %H:%M:%S")
  back = time_now + datetime.timedelta(days=-1)
  back_date = back.strftime("%Y-%m-%d %H:%M:%S")
  print "Content-type: text/html\n\n"
  print "<center>"
  print "<H1>SEARCH CALL DETAIL RECORDS</H1>"
  print "</center>"
  print "<br><br>"
  print "<form action=cdr_rpt.py>"
  print "<input type=text name=sdate size=20 "
  print "value='" + back_date
  print "'>&nbsp;Start Date/Time<br>"
  print "<input type=text name=edate size=20 "
  print "value='" + current_date
  print "'>&nbsp;End Date/Time<br>"
  print "<input type=text name=search size=20>&nbsp;Search String<br>"
  print "<input type=text name=src size=20>&nbsp;Source<br>"
  print "<input type=text name=dst size=20>&nbsp;Destination<br>"
  print "<input type=text name=channel size=20>&nbsp;Channel<br>"
  print "<input type=text name=dstchannel size=20>&nbsp;Dest Channel<br>"
  print "<input type=text name=dcontext size=20>&nbsp;Context"
  print "<br><br>"
  print "<input type=submit>"
  print "&nbsp;&nbsp;"
  print "<input type=reset>"
  print "</form>"

def print_result(result):
 print "<table border=1>"
 print "<th>Date</th><th>Source</th><th>Destination</th><th>Duration</th><th>Context</th>"
 print "<th>Dest Channel</th><th>Channel</th>"
 for record in result:
   id = record[0]
   billed = record[1]
   uniqueid = record[2]
   userfield = record[3] 
   accountcode = record[4]
   src  = record[5]
   dst = record[6]
   dcontext = record[7]
   clid = record[8]
   channel = record[9]
   dstchannel = record[10]
   lastapp = record[11]
   lastdata = record[12]
   calldate = record[13]
   duration = record[14]
   billsec = record[15]
   disposition = record[16]
   print "<tr>"
   print "<td NOWRAP align=center>%s</td>"    % calldate
   print "<td NOWRAP align=center>%s</td>"    % src     
   print "<td NOWRAP align=center>%s</td>"    % dst     
   print "<td NOWRAP align=center>%s</td>"    % duration
   print "<td NOWRAP align=center>%s</td>"    % dcontext
   print "<td NOWRAP align=center>%s</td>"    % dstchannel 
   print "<td NOWRAP align=center>%s</td>"    % channel 
   print "</tr>"
 print "</table>"

query = ""
form=cgi.FieldStorage()
if form.has_key("sdate"):
  sdate = form["sdate"].value
  edate = form["edate"].value
  query = "SELECT * FROM cdr where (calldate >= '" + sdate + "')"
  query = query + " and (calldate <= '" + edate + "')" 
  if form.has_key("search"):
    search  = form["search"].value
    query = query + " and (" 
    query = query + "(dcontext       like '%" + search + "%')" 
    query = query + " OR (src        like '%" + search + "%')" 
    query = query + " OR (dst        like '%" + search + "%')" 
    query = query + " OR (dstchannel like '%" + search + "%')" 
    query = query + " OR (channel    like '%" + search + "%')" 
    query = query + ")" 
  if form.has_key("dst"):
    dst  = form["dst"].value
    query = query + " and (" 
    query = query + " (dst        like '%" + dst + "%')" 
    query = query + ")" 
  if form.has_key("src"):
    src  = form["src"].value
    query = query + " and (" 
    query = query + " (src        like '%" + src + "%')" 
    query = query + ")" 
  if form.has_key("dcontext"):
    dcontext = form["dcontext"].value
    query = query + " and (" 
    query = query + " (dcontext   like '%" + dcontext + "%')" 
    query = query + ")" 
  if form.has_key("channel"):
    channel = form["channel"].value
    query = query + " and (" 
    query = query + " (channel    like '%" + channel + "%')" 
    query = query + ")" 
  if form.has_key("dstchannel"):
    dstchannel = form["dstchannel"].value
    query = query + " and (" 
    query = query + " (dstchannel like '%" + dstchannel + "%')" 
    query = query + ")" 
  if query != "":
    query = query + " order by id desc"
    print "Content-type: text/html\n\n"
    print "<link rel='stylesheet' type='text/css' href='/asterisk/style/style.css'>"
    print "<center><H1>CALL DETAIL RECORDS</H1></center>"
    db = MySQLdb.connect(host="localhost",user="asteriskuser",passwd="asterisk",db="asterisk")
    cursor = db.cursor()
    cursor.execute(query)
    result = cursor.fetchall()
    print_result(result)
else:
 html_form()
