#!/bin/env python

# Copyright (C) 2006 Earl C. Terwilliger   earl@micpc.com
#
# Reads MySql table to create HTML output for Event records

import cgi, sys, string, os, time, datetime, MySQLdb

def html_form():
  time_now = datetime.datetime.now()
  current_date = time_now.strftime("%Y-%m-%d %I:%M:%S")
  back = time_now + datetime.timedelta(days=-1)
  back_date = back.strftime("%Y-%m-%d %I:%M:%S")
  print "Content-type: text/html\n\n"
  print "<center>"
  print "<H1>DISPLAY EVENT RECORDS</H1>"
  print "</center>"
  print "<br><br>"
  print "<form action=event_rpt.py>"
  print "<input type=text name=sdate size=20 "
  print "value='" + back_date
  print "'>&nbsp;Start Date/Time<br>"
  print "<input type=text name=edate size=20 "
  print "value='" + current_date
  print "'>&nbsp;End Date/Time<br>"
  print "<br><br>"
  print "<input type=submit>"
  print "&nbsp;&nbsp;"
  print "<input type=reset>"
  print "</form>"

def print_result(result):
 print "<table width='100%' cellpadding=2 cellspacing=0 border=1>\n"
 print "<tr><th>ID</th><th>TIME STAMP</th><th>EVENT</th>\n"
 print "<th>PRIVILEGE</th><th>CHANNEL / PEER / DATA</th><th>STATUS / DATA</th>\n"
 print "<th>DATA</th></tr>\n"
 rows = 0
 for record in result:
   id         = record[0]
   timestamp  = record[1]
   event      = record[2]
   flds = string.split(event,"  ")
   if (rows%2) == 0 : print "<tr>"
   else :             print "<tr bgcolor=#D3D3D3>"

   print "<td NOWRAP align=left>%s</td>"    % id       
   print "<td NOWRAP align=left>%s</td>"    % timestamp
   
   lf = len(flds)
   if lf < 4:
     for x in range(0,lf):
        print "<td NOWRAP>" + cgi.escape(flds[x]) + "</td>"
     for x in range(lf,5):
        print "<td NOWRAP>&nbsp;</td>"
   else :
     for x in range(0,4):
        print "<td NOWRAP>" + cgi.escape(flds[x]) + "</td>"
     if lf > 4:
       print "<td NOWRAP>"
       for x in range(4,lf):
         print cgi.escape(flds[x]) + "  "
       print "</td>"
     else: print "<td NOWRAP>&nbsp;</td>"
   print "</tr>"
   rows += 1
 print "</table>"

query = ""
form=cgi.FieldStorage()
if form.has_key("sdate"):
  sdate = form["sdate"].value
  edate = form["edate"].value
  query = "SELECT * FROM events where (timestamp >= '" + sdate + "')"
  query = query + " and (timestamp <= '" + edate + "')" 
  query = query + " order by id" 
  print "Content-type: text/html\n\n"
  print "<link rel='stylesheet' type='text/css' href='/asterisk/style/style.css'>"
  print "<center><H1>EVENT RECORDS</H1></center>"
  db = MySQLdb.connect(host="localhost",user="asteriskuser",passwd="asterisk",db="asterisk")
  cursor = db.cursor()
  cursor.execute(query)
  result = cursor.fetchall()
  print_result(result)
else:
 html_form()
