<?php
/* 
 Copyright (C) 2005-2007 Earl C. Terwilliger
 Email contact: earl@micpc.com

 Name : firewall.php
 Usage: PHP script to add/delete IPTABLES commands for Asterisk 

    This file is part of The Asterisk WEB/PHP Management Interface.

    These files are free software; you can redistribute them and/or modify
    them under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    These programs are distributed in the hope that they will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with these files (see COPYING); if not, write to the:

         Free Software Foundation, Inc.
         59 Temple Place
         Suite 330
         Boston, MA  02111-1307
         USA
*/

include('header.php');
include('files.php');
include('functions.php');

if (isset($_POST['submit'])) {
  $function  = $_POST['function'];
  if ($function == "add") {
    echo "<PRE>\n";
    echo "Turning On the IPTABLES rules for Asterisk ...<br>\n";
    flush();
// SIP on UDP port 5060  
    myexec("/sbin/iptables -A INPUT -p udp -m udp --dport 5060 -j ACCEPT");
// IAX2 - the IAX protocol 
    myexec("/sbin/iptables -A INPUT -p udp -m udp --dport 4569 -j ACCEPT");
// IAX  - most have switched to IAX v2, or ought to 
    myexec("/sbin/iptables -A INPUT -p udp -m udp --dport 5036 -j ACCEPT");
// RTP - the media stream 
    myexec("/sbin/iptables -A INPUT -p udp -m udp --dport 10000:20000 -j ACCEPT");
//  MGCP - if you use media gateway control protocol in your configuration 
    myexec("/sbin/iptables -A INPUT -p udp -m udp --dport 2727 -j ACCEPT");
    flush();
    echo "<br>Complete.<br>\n";
    echo "</PRE>\n";
    flush();
    exit();
  }
  if ($function == "delete") {
    echo "<PRE>\n";
    echo "Turning Off the IPTABLES rules for Asterisk ...<br>\n";
    flush();
// SIP on UDP port 5060  
    myexec("/sbin/iptables -D INPUT -p udp -m udp --dport 5060 -j ACCEPT");
// IAX2 - the IAX protocol 
    myexec("/sbin/iptables -D INPUT -p udp -m udp --dport 4569 -j ACCEPT");
// IAX  - most have switched to IAX v2, or ought to 
    myexec("/sbin/iptables -D INPUT -p udp -m udp --dport 5036 -j ACCEPT");
// RTP - the media stream 
    myexec("/sbin/iptables -D INPUT -p udp -m udp --dport 10000:20000 -j ACCEPT");
//  MGCP - if you use media gateway control protocol in your configuration 
    myexec("/sbin/iptables -D INPUT -p udp -m udp --dport 2727 -j ACCEPT");
    echo "<br>Complete.<br>\n";
    flush();
    echo "</PRE>\n";
    exit();
  }
  if ($function == "list") {
    echo "<PRE>\n";
    echo "Listing the IPTABLES rules ...<br>\n";
    mysystem("/sbin/iptables -L");
    echo "<br>Complete.<br>\n";
    flush();
    echo "</PRE>\n";
    exit();
  }
  echo "<PRE>\n";
  echo "Nothing to do?<br>\n"; 
  echo "</PRE>\n";
  flush();
  exit();
}
else {
?>
<br>
<H1>Firewall [IPTABLES] COMMANDS FOR ASTERISK</H1>
<center>
<form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="post">
<input type=radio name="function" value="delete">&nbsp;Delete
<input type=radio name="function" value="add">&nbsp;Add
<input type=radio name="function" value="list" checked>&nbsp;List
<br>
<br>
<input type="submit" name="submit" value="Submit">&nbsp;&nbsp;
<input type="reset"  value="Reset">
</form>
</center>
<?php } ?>
