<?php
/* 
 Copyright (C) 2005-2007 Earl C. Terwilliger
 Email contact: earl@micpc.com

 Name : functions.php 
 Usage: provides common functions used by other PHP scripts
        included into other PHP scripts

    This file is part of The Asterisk WEB/PHP Management Interface.

    These files are free software; you can redistribute them and/or modify
    them under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    These programs are distributed in the hope that they will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with these files (see COPYING); if not, write to the:

         Free Software Foundation, Inc.
         59 Temple Place
         Suite 330
         Boston, MA  02111-1307
         USA
*/

function mysystem($command) {
 if (substr($command,0,4) != "sudo") $command = "sudo -u root " . $command;
 if (!($p=popen("($command)2>&1","r"))) return 126;
 while (!feof($p)) {
     $l=fgets($p,4096);
     $l = trim($l);
     echo $l;
     echo "<br>";
     flush();
 }
 pclose($p);
 flush();
 return;
}

function myexec($command) {
 if (substr($command,0,4) != "sudo") $command = "sudo -u root " .  $command ;
 if (!($p=popen("($command)2>&1","r"))) return 126;
 while (!feof($p)) fgets($p,4096);
 pclose($p);
 return;
}

function astercon($command) {
 GLOBAL $ASTERCMD;
 $command = escapeshellarg($command);
 myexec("sudo $ASTERCMD $command");
}

function astersys($command) {
 GLOBAL $ASTERCMD;
 $command = escapeshellarg($command);
 mysystem("sudo $ASTERCMD $command");
}

function myprocexec($command,$input) {
  $descriptorspec = array(
     0 => array("pipe", "r"),  
     1 => array("pipe", "w"),  
     2 => array("pipe", "w") 
  );
  $process = proc_open($command, $descriptorspec, $pipes);
  if (is_resource($process)) {
      echo "<pre>";
      echo "Command: $command<br>";
      echo "<br>Stdin:<br>";
      echo "$input<br>";
      fwrite($pipes[0],$input);
      fclose($pipes[0]);
      echo "<br>Stdout:<br>";
      while(!feof($pipes[1])) {
       echo trim(fgets($pipes[1], 1024));
       echo "<br>";
      }
      fclose($pipes[1]);
      echo "<br>Stderr:<br>";
      while(!feof($pipes[2])) {
       echo trim(fgets($pipes[2], 1024));
       echo "<br>";
      }
      fclose($pipes[2]);
      echo "</pre>";
      $rc = proc_close($process);
  }
}
function tcontrol($dev,$ceil,$rate,$halfrate,$bulk,$police) {
  $filename = "/tmp/tc.sh";
  if (!$handle = fopen($filename, 'w')) {
    echo "Cannot open file ($filename)";
    exit;
  }
  fwrite($handle,"#!/bin/bash\n");
  fwrite($handle,"#\n");
  fwrite($handle,"#           ----------\n");
  fwrite($handle,"#           | $dev  |\n");
  fwrite($handle,"#           ----------\n"); 
  fwrite($handle,"#              |\n"); 
  fwrite($handle,"#        ------------\n"); 
  fwrite($handle,"#        |  PRIO    | 1:0  root qdisc\n"); 
  fwrite($handle,"#        ------------\n"); 
  fwrite($handle,"#       /            \\\n"); 
  fwrite($handle,"#      / 1:1          \\ 1:2    qdisc\n"); 
  fwrite($handle,"#     /                \\\n");
  fwrite($handle,"# ---------       --------------------\n"); 
  fwrite($handle,"# | PFIO  | 10:   |     HTB          |  10:   qdisc\n"); 
  fwrite($handle,"# ---------       --------------------\n"); 
  fwrite($handle,"#                  | :10     | :20  \\ :40     class\n"); 
  fwrite($handle,"#               --------- ---------  \\\n"); 
  fwrite($handle,"#               | PFIFO | | PFIFO |   \\         qdisc \n"); 
  fwrite($handle,"#               --------- ---------   -------\n"); 
  fwrite($handle,"#                                     | SFQ |   qdisc\n"); 
  fwrite($handle,"#                                     -------\n"); 
  fwrite($handle,"#\n"); 
  fwrite($handle,"#\n"); 
  fwrite($handle,"#\n"); 
  fwrite($handle,"tc qdisc del dev $dev ingress\n"); 
  fwrite($handle,"tc qdisc add dev $dev handle ffff: ingress\n"); 
  fwrite($handle,"tc filter add dev $dev parent ffff: protocol ip prio 100 u32 match ip src 0.0.0.0/0 police rate $police burst 10k drop flowid :1\n"); 
  fwrite($handle,"ifconfig $dev txqueuelen 10\n"); 
  fwrite($handle,"#\n"); 
  fwrite($handle,"tc qdisc del root dev $dev\n"); 
  fwrite($handle,"#\n"); 
  fwrite($handle,"tc qdisc add dev $dev root handle 1: prio bands 2 priomap 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1\n"); 
  fwrite($handle,"#\n"); 
  fwrite($handle,"tc qdisc add dev $dev parent 1:1 handle  11:  pfifo\n"); 
  fwrite($handle,"tc qdisc add dev $dev parent 1:2 handle  10:  htb default 40\n"); 
  fwrite($handle,"#\n"); 
  fwrite($handle,"tc class add dev $dev parent 10:  classid 10:1  htb rate $rate\n"); 
  fwrite($handle,"tc class add dev $dev parent 10:1 classid 10:10 htb rate $rate ceil $ceil quantum 1500\n"); 
  fwrite($handle,"tc class add dev $dev parent 10:1 classid 10:20 htb rate $halfrate ceil $ceil\n"); 
  fwrite($handle,"tc class add dev $dev parent 10:1 classid 10:40 htb rate $bulk     ceil $ceil quantum 1500\n"); 
  fwrite($handle,"tc qdisc add dev $dev parent 10:10 handle 100: pfifo limit 50\n"); 
  fwrite($handle,"tc qdisc add dev $dev parent 10:20 handle 200: pfifo limit 10\n"); 
  fwrite($handle,"tc qdisc add dev $dev parent 10:40 handle 400: sfq   perturb 10\n"); 
  fwrite($handle,"#\n"); 
  fwrite($handle,"tc filter add dev $dev protocol ip parent 1: prio 1 u32 match ip sport 5036 0xffff flowid 1:1\n"); 
  fwrite($handle,"tc filter add dev $dev protocol ip parent 1: prio 1 u32 match ip dport 5036 0xffff flowid 1:1\n"); 
  fwrite($handle,"tc filter add dev $dev protocol ip parent 1: prio 1 u32 match ip sport 4569 0xffff flowid 1:1\n"); 
  fwrite($handle,"tc filter add dev $dev protocol ip parent 1: prio 1 u32 match ip dport 4569 0xffff flowid 1:1\n"); 
  fwrite($handle,"#\n"); 
  fwrite($handle,"tc filter add dev $dev protocol ip parent 1: prio 1 u32 match ip icmp_type 0x08 0xff flowid 1:1\n"); 
  fwrite($handle,"tc filter add dev $dev protocol ip parent 1: prio 1 u32 match ip icmp_type 0x00 0xff flowid 1:1\n"); 
  fwrite($handle,"#\n"); 
  fwrite($handle,"tc filter add dev $dev protocol ip parent 1: prio 2 u32 match ip src 0.0.0.0/0 flowid 1:2\n"); 
  fwrite($handle,"tc filter add dev $dev protocol ip parent 1: prio 2 u32 match ip dst 0.0.0.0/0 flowid 1:2\n"); 
  fwrite($handle,"#\n"); 
  fwrite($handle,"tc filter add dev $dev protocol ip parent 10: prio 1 u32 match ip sport 22 0xffff flowid 10:10\n"); 
  fwrite($handle,"tc filter add dev $dev protocol ip parent 10: prio 1 u32 match ip dport 22 0xffff flowid 10:10\n"); 
  fwrite($handle,"#\n"); 
  fwrite($handle,"tc filter add dev $dev protocol ip parent 1: prio 1 u32 match ip src 0.0.0.0 match ip protocol 17 0xff flowid 1:1\n"); 
  fwrite($handle,"tc filter add dev $dev protocol ip parent 1: prio 1 u32 match ip dst 0.0.0.0 match ip protocol 17 0xff flowid 1:1\n"); 
  fwrite($handle,"#\n"); 
  fwrite($handle,"PORTS=\"1720 15328 15329 15330 15331 15332 3230 3231 3232 3233 3234 3235 3236 3237 3238 3239 3240 3241 3242 3243 3243 3244 3245 3246 3247\"\n"); 
  fwrite($handle,"#\n"); 
  fwrite($handle,"for PORT in " . "$" ."PORTS; do\n"); 
  fwrite($handle,"tc filter add dev $dev protocol ip parent 10: prio 1 u32 match ip sport $" . "PORT 0xffff flowid 10:20\n"); 
  fwrite($handle,"tc filter add dev $dev protocol ip parent 10: prio 1 u32 match ip dport $" . "PORT 0xffff flowid 10:20\n"); 
  fwrite($handle,"done\n"); 
  fwrite($handle,"#\n"); 
  fwrite($handle,"tc filter add dev $dev protocol ip parent 10: prio 1 u32 match ip src 0.0.0.0/0 flowid 10:40\n"); 
  fwrite($handle,"tc filter add dev $dev protocol ip parent 10: prio 1 u32 match ip dst 0.0.0.0/0 flowid 10:40\n"); 
  fclose($handle);
  mysystem("/bin/bash -x <$filename\n");
  unlink($filename);
}
?>
