<?php
/* 
 Copyright (C) 2005-2007 Earl C. Terwilliger
 Email contact: earl@micpc.com

 Name : login.php 
 Usage: Provides info from the /etc/manager.conf file to other PHP scripts
        Also logs into the Asterisk manager interface

    This file is part of The Asterisk WEB/PHP Management Interface.

    These files are free software; you can redistribute them and/or modify
    them under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    These programs are distributed in the hope that they will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with these files (see COPYING); if not, write to the:

         Free Software Foundation, Inc.
         59 Temple Place
         Suite 330
         Boston, MA  02111-1307
         USA
*/
include('files.php');

$general = 0;
$enabled = 0;
$astmanager  = "";
$astpassword = "";
$astip       = "127.0.0.1";
$astport     = "5038";
$errno       = "";
$errstr      = "";
$timeout     = "30";

$fname = $ASTMANAGERFILE;

$fd = fopen ($fname, "r");
if (!$fd) {
 echo "An error occurred determining the Asterisk Manager Configuration!<br>"; 
 echo "The PHP/WEB interface could not open the file -> $fname <br>"; 
 exit(0);
}

while (!feof ($fd)) {
  $buffer = fgets($fd, 4096);
  $l = trim($buffer);
  $pattern = '/^\s*\[(.*?)\]/';
  if (preg_match($pattern,$l,$matches)) {
    if ($matches[0] == "general") {
      $general = 1;
    }
    else {
       $astmanager = $matches[1];
    }
    continue;
  }
  $pattern  = '/^\s*(\w+)\s*=>\s*(.+)\s*;?.*$/';
  if (preg_match($pattern,$l,$matches)) { 
      if (strtolower($matches[0]) == "enabled = yes") {
        $enabled = 1;
        continue;
      }
      if (substr(strtolower($matches[0]),0,9) == "secret = ") {
        $astpassword = $matches[2];
        continue;
      }
      if (substr(strtolower($matches[0]),0,7) == "port = ") {
        $astport = $matches[2];
        continue;
      }
  }
  $pattern  = '/^\s*(\w+)\s*=\s*(.+)\s*;?.*$/';
  if (preg_match($pattern,$l,$matches)) { 
      if (strtolower($matches[0]) == "enabled = yes") {
        $enabled = 1;
        continue;
      }
      if (substr(strtolower($matches[0]),0,9) == "secret = ") {
        $astpassword = $matches[2];
        continue;
      }
      if (substr(strtolower($matches[0]),0,7) == "port = ") {
        $astport = $matches[2];
        continue;
      }
  }
}
fclose ($fd); 

if ($enabled == 0) {
 echo "The Asterisk Manager Configuration is not enabled!"; 
 echo "<br>Please check the file -> $fname to enable it!"; 
 echo "<br>Enabled  : " . $enabled;
 echo "<br>Manager  : " . $astmanager;
 echo "<br>Password : " . $astpassword;
 echo "<br>IP       : " . $astip;
 echo "<br>Port     : " . $astport;
 exit(0);
}

$socket = fsockopen($astip,$astport,$errno,$errstr,$timeout);
if (!$socket) {
    echo "<pre>";
    echo "$errstr ($errno)<br>\n";
    echo "</pre>";
    exit(99);
}

fputs($socket, "Action: Login\r\n");
fputs($socket, "UserName: $astmanager\r\n");
fputs($socket, "Secret: $astpassword\r\n\r\n");

?>
