<?php
/* 
 Copyright (C) 2005-2007 Earl C. Terwilliger
 Email contact: earl@micpc.com

 Name : mailbox.php 
 Usage: PHP script to add/delete a voice mail box 

    This file is part of The Asterisk WEB/PHP Management Interface.

    These files are free software; you can redistribute them and/or modify
    them under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    These programs are distributed in the hope that they will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with these files (see COPYING); if not, write to the:

         Free Software Foundation, Inc.
         59 Temple Place
         Suite 330
         Boston, MA  02111-1307
         USA
*/

include('header.php');
include('files.php');
include('functions.php');

if (isset($_POST['submit'])) {
  $context   = $_POST['context'];
  $mailbox   = $_POST['mailbox'];
  $function  = $_POST['function'];
  if ($context == "") $context = "default";
  if ($mailbox == "") {
   echo "<PRE>\n";
   echo "Error: You must supply a numeric mailbox for the $function function.";
   echo "</PRE>\n";
   exit();
  }
  if ($function == "add") {
    echo "<PRE>\n";
    echo "Creating Voicemail context directory [if it does not already exist] ...<br>\n";
    flush();
    myexec("mkdir -p $VMHOME/$context");
    echo "Creating Voicemail directory $VMHOME/$context/$mailbox<br>\n"; 
    flush();
    myexec("mkdir -p $VMHOME/$context/$mailbox");
    echo "Creating INBOX...<br>\n";
    flush(); 
    myexec("mkdir -p $VMHOME/$context/$mailbox/INBOX");
    echo "Creating Default greetings ... <br>\n"; 
    flush();
    myexec("cat $SNDHOME/vm-theperson.gsm > $VMHOME/$context/$mailbox/unavail.gsm");
    myexec("cat $SNDHOME/vm-theperson.gsm > $VMHOME/$context/$mailbox/busy.gsm");
    myexec("cat $SNDHOME/vm-extension.gsm > $VMHOME/$context/$mailbox/greet.gsm");
    $i = strlen($mailbox);
    for($c=0;$c<$i;++$c) {
       $x = substr($mailbox,$c,1);
       myexec("cat $SNDHOME/digits/$x.gsm >> $VMHOME/$context/$mailbox/unavail.gsm");
       myexec("cat $SNDHOME/digits/$x.gsm >> $VMHOME/$context/$mailbox/busy.gsm");
       myexec("cat $SNDHOME/digits/$x.gsm >> $VMHOME/$context/$mailbox/greet.gsm");
    }
    myexec("cat $SNDHOME/vm-isunavail.gsm >> $VMHOME/$context/$mailbox/unavail.gsm");
    myexec("cat $SNDHOME/vm-isonphone.gsm >> $VMHOME/$context/$mailbox/busy.gsm");
    echo "Complete.<br>\n";
    echo "</PRE>\n";
    flush();
    exit();
  }
  if ($function == "delete") {
    echo "<PRE>\n";
    echo "Deleting Voicemail directory $VMHOME/$context/$mailbox<br>\n"; 
    flush();
    myexec("rm -rf $VMHOME/$context/$mailbox");
    echo "Complete.<br>\n";
    flush();
    echo "</PRE>\n";
    exit();
  }
  echo "<PRE>\n";
  echo "Nothing to do?<br>\n"; 
  flush();
  echo "</PRE>\n";
  exit();
}
else {
?>
<br>
<center>
<form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="post">
Mail Box Number&nbsp;&nbsp;<input type="text" name="mailbox" size="8">
&nbsp;&nbsp;
Context&nbsp;&nbsp;<input type="text" name="context" size="20">
&nbsp;[blank = default]
            <input type=radio name="function" value="delete"     >&nbsp;Delete
&nbsp;&nbsp;<input type=radio name="function" value="add" checked>&nbsp;Add
<br>
<br>
<input type="submit" name="submit" value="Submit">&nbsp;&nbsp;
<input type="reset"  value="Reset">
</form>
</center>
<?php } ?>
