<?php
/* 
 Copyright (C) 2005-2007 Earl C. Terwilliger
 Email contact: earl@micpc.com

 Name : originate.php 
 Usage: PHP script to originate a call via the web to Asterisk 

    This file is part of The Asterisk WEB/PHP Management Interface.

    These files are free software; you can redistribute them and/or modify
    them under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    These programs are distributed in the hope that they will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with these files (see COPYING); if not, write to the:

         Free Software Foundation, Inc.
         59 Temple Place
         Suite 330
         Boston, MA  02111-1307
         USA
*/

include('files.php');
include('header.php');

$astdir = $ASTOUTGOINGDIR;
$tmpdir = $TMPDIR;

if (isset($_POST['submit'])) {

  $channel  = $_POST['channel'];
  $exten    = $_POST['extension'];
  $context  = $_POST['context'];
  $prio     = $_POST['prio'];
  $timeout  = $_POST['timeout'];  
  $callerid = $_POST['callerid'];  
  $variable = $_POST['variable'];  
  $account  = $_POST['account'];  
  $app      = $_POST['application'];
  $data     = $_POST['data'];
  $async    = $_POST['async'];
  $actionid = $_POST['actionid'];

 if (substr($_POST['submit'],0,1) == "S") {
  $action = "Action: Originate\r\n";
  if ($channel != "")
    $call   = "Channel: $channel\r\n";
  if ($exten   != "")
    $call  .= "Exten: $exten\r\n";
  if ($context != "")
    $call  .= "Context: $context\r\n";
  if ($prio    != "")
    $call  .= "Priority: $prio\r\n";
  if ($timeout != "")
    $call  .= "Timeout: $timeout\r\n";
  if ($callerid != "")
    $call  .= "Callerid: $callerid\r\n";
  if ($variable != "")
    $call  .= "Variable: $variable\r\n";
  if ($account != "")
    $call  .= "Account: $account\r\n";
  if ($app     != "")
    $call  .= "Application: $app\r\n";
  if ($data    != "")
    $call  .= "Data: $data\r\n";
  if ($async   != "")
    $call  .= "Async: $async\r\n";
  if ($actionid != "")
    $call  .= "ActionID: $actionid\r\n";
  $call  .= "\r\n";
 
  include('login.php');

  fputs($socket, $action);
  fputs($socket, $call);
  fputs($socket, "Action: Logoff\r\n\r\n");

  $w = "";

  while (!feof($socket)) {
    $w .= fread($socket, 8192);
  }
  fclose($socket);

  echo "<pre>";
  echo <<<ASTERISKMANAGEREND
  $w
ASTERISKMANAGEREND;
  echo "</pre>";
 }
 else {
    if ($channel != "")
      $call   = "Channel: $channel\r\n";
    if ($exten   != "")
      $call  .= "Extension: $exten\r\n";
    if ($context != "")
      $call  .= "Context: $context\r\n";
    if ($prio    != "")
      $call  .= "Priority: $prio\r\n";
    if ($timeout != "")
      $call  .= "Timeout: $timeout\r\n";
    if ($callerid != "")
      $call  .= "Callerid: $callerid\r\n";
    if ($variable != "")
      $call  .= "Variable: $variable\r\n";
    if ($account != "")
      $call  .= "Account: $account\r\n";
    if ($app     != "")
      $call  .= "Application: $app\r\n";
    if ($data    != "")
      $call  .= "Data: $data\r\n";
    $call  .= "\r\n";
    echo "<pre>";
    echo $call;
    echo "</pre>";

    $tmpfname = tempnam($tmpdir, "CallFile");
    $callfile = $tmpdir . basename($tmpfname);
    if (substr($tmpfname,0,strlen($tmpdir)) != $tmpdir) {
      echo "Error opening Call File in $tmpdir<br>";
      echo "Make sure the web server has authority to write in this directory!<br>";
      exit();
    }
    $handle = fopen($tmpfname, "w");
    if ($handle  == FALSE) {
      echo "Error opening $tmpfname<br>";
      echo "Make sure the web server has authority to save this file!<br>";
      exit();
    }
    fwrite($handle, $call);
    fclose($handle);
    $time_now = time( );
    if (!touch($tmpfname, $time_now, $time_now )) {
      echo "Error changing date on Call File $tmpfname<br>";
      echo "Make sure the web server has authority to change this file/directory!<br>";
      exit();
    }
    if (!rename( $tmpfname, $callfile )) {
      echo "Error renaming Call File $tmpfname to $callfile<br>";
      echo "Make sure the web server has authority to rename this file!<br>";
      exit();
    }

    echo "Created Call File $callfile<br>";
 }
}
else {
?>
<center>
<form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="post">
<input type="submit" name="submit" value="Submit to Manager Interface">&nbsp;&nbsp;
<input type="submit" name="submit"
  value="Create Call File in <?php echo $astdir; ?>">&nbsp;&nbsp;
<input type="reset"  value="Reset">
<br>
<br>
<table>
<tr>
<td>Channel</td>
<td><input type="text" name="channel" size="20"></td>
</tr><tr>
<td>Context</td>
<td><input type="text" name="context" size="20"></td>
</tr><tr>
<td>Extension</td>
<td><input type="text" name="extension"  size="20"></td>
</tr><tr>
<td>Priority</td>
<td><input type="text" name="prio"    size="4"></td>
</tr><tr>
<td>Timeout</td>
<td><input type="text" name="timeout" size="4"></td>
</tr><tr>
<td>CallerID</td>
<td><input type="text" name="callerid" size="20"></td>
</tr><tr>
<td>Variable</td>
<td><input type="text" name="variable" size="20"></td>
</tr><tr>
<td>Account</td>
<td><input type="text" name="account" size="20"></td>
</tr><tr>
<td>Application</td>
<td><input type="text" name="application" size="20"></td>
</tr><tr>
<td>Data</td>
<td><input type="text" name="data" size="20"></td>
</tr><tr>
<td>Async</td>
<td><input type="text" name="async" size="20"></td>
</tr><tr>
<td>ActionID</td>
<td><input type="text" name="actionid" size="4"></td>
</tr>
</table>
<br>
</form>
</center>
<?php } ?>
