<?PHP
/* 
 Copyright (C) 2005-2007 Earl C. Terwilliger
 Email contact: earl@micpc.com

 Name : parseconf.php 
 Usage: PHP script to parse the /etc/asterisk  .conf files
        This is a script helpful in debugging problems        

    This file is part of The Asterisk WEB/PHP Management Interface.

    These files are free software; you can redistribute them and/or modify
    them under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    These programs are distributed in the hope that they will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with these files (see COPYING); if not, write to the:

         Free Software Foundation, Inc.
         59 Temple Place
         Suite 330
         Boston, MA  02111-1307
         USA
*/
include('files.php');
include("header.php");

/*
change $fname file to any conf file for parsing
*/

$fname = $ASTMANAGERFILE;

$fd = fopen ($fname, "r");
if (!$fd) {
 echo "Error opening $fname"; 
 exit(0);
}
while (!feof ($fd)) {
    $buffer = fgets($fd, 4096);
    $l = trim($buffer);
    echo $l."<br>";
    $pattern = '/^\s*;/';
    if (preg_match($pattern,$l,$matches)) { print_r($matches); echo "<br>"; }
    $pattern = '/^\s*\[(.*?)\]/';
    if (preg_match($pattern,$l,$matches)) { print_r($matches); echo "<br>"; }
    $pattern = '/^\s*(\w+)\s*=>\s*(.+)\s*;?.*$/';
    if (preg_match($pattern,$l,$matches)) { print_r($matches); echo "<br>"; }
    $pattern = '/^\s*(\w+)\s*=\s*(.+)\s*;?.*$/';
    if (preg_match($pattern,$l,$matches)) { print_r($matches); echo "<br>"; }
    flush();
}
fclose ($fd); 
?>
