<?php
/* 
 Copyright (C) 2005-2007 Earl C. Terwilliger
 Email contact: earl@micpc.com

 Name : placecall.php 
 Usage: PHP script to originate a call via the web to Asterisk 

    This file is part of The Asterisk WEB/PHP Management Interface.

    These files are free software; you can redistribute them and/or modify
    them under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    These programs are distributed in the hope that they will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with these files (see COPYING); if not, write to the:

         Free Software Foundation, Inc.
         59 Temple Place
         Suite 330
         Boston, MA  02111-1307
         USA
*/

include('header.php');

  if (isset($_POST['calltype']))    $calltype = $_POST['calltype'];
  else                              $calltype = "";
  if (isset($_POST['channel']))     $channel  = $_POST['channel'];
  else                              $channel  = "";
  if (isset($_POST['exten']))  	    $exten    = $_POST['exten'];
  else                              $exten    = "";
  if (isset($_POST['context']))     $context  = $_POST['context'];
  else                              $context  = "";
  if (isset($_POST['prio']))  	    $prio     = $_POST['prio'];
  else                              $prio     = "1";
  if (isset($_POST['timeout']))     $timeout  = $_POST['timeout'];  
  else                              $timeout  = "";
  if (isset($_POST['callerid']))    $callerid = $_POST['callerid'];  
  else                  	    $callerid = $channel;  
  if (isset($_POST['variable']))    $variable = $_POST['variable'];  
  else                              $variable = "";
  if (isset($_POST['account']))     $account  = $_POST['account'];  
  else                              $account  = "";
  if (isset($_POST['application'])) $app      = $_POST['application'];
  else                              $app      = "";
  if (isset($_POST['data']))   	    $data     = $_POST['data'];
  else                              $data     = "";
  if (isset($_POST['async'])) 	    $async    = $_POST['async'];
  else                              $async    = "";
  if (isset($_POST['actionid']))    $actionid = $_POST['actionid'];
  else                              $actionid = "1";

  if ($calltype == 'file') {
    if ($channel != "")
      $call   = "Channel: $channel\r\n";
    if ($exten   != "")
      $call  .= "Extension: $exten\r\n";
    if ($context != "")
      $call  .= "Context: $context\r\n";
    if ($prio    != "")
      $call  .= "Priority: $prio\r\n";
    if ($timeout != "")
      $call  .= "Timeout: $timeout\r\n";
    if ($callerid != "")
      $call  .= "Callerid: $callerid\r\n";
    if ($variable != "")
      $call  .= "Variable: $variable\r\n";
    if ($account != "")
      $call  .= "Account: $account\r\n";
    if ($app     != "")
      $call  .= "Application: $app\r\n";
    if ($data    != "")
      $call  .= "Data: $data\r\n";
    $call  .= "\r\n";
    echo "<pre>";
    echo $call;
    echo "</pre>";
    include('files.php');
    $astdir = $ASTOUTGOINGDIR;
    $tmpfname = tempnam($astdir, "CallFile");
    if (substr($tmpfname,0,strlen($astdir)) != $astdir) {
     echo "Error opening Call File in $astdir<br>";
     echo "Make sure the web server has authority to write in this directory!<br>";
     exit();
    }
    $handle = fopen($tmpfname, "w");
    if ($handle  == FALSE) {
        echo "Error opening $tmpfname<br>";
        echo "Make sure the web server has authority to save this file!<br>";
        exit();
    }
    fwrite($handle, $call);
    fclose($handle);
    echo "Created Call File $tmpfname<br>";
    exit();
  }

  $action = "Action: Originate\r\n";
  if ($channel != "")
    $call   = "Channel: $channel\r\n";
  if ($exten   != "")
    $call  .= "Exten: $exten\r\n";
  if ($context != "")
    $call  .= "Context: $context\r\n";
  if ($prio    != "")
    $call  .= "Priority: $prio\r\n";
  if ($timeout != "")
    $call  .= "Timeout: $timeout\r\n";
  if ($callerid != "")
    $call  .= "Callerid: $callerid\r\n";
  if ($variable != "")
    $call  .= "Variable: $variable\r\n";
  if ($account != "")
    $call  .= "Account: $account\r\n";
  if ($app     != "")
    $call  .= "Application: $app\r\n";
  if ($data    != "")
    $call  .= "Data: $data\r\n";
  if ($async   != "")
    $call  .= "Async: $async\r\n";
  if ($actionid != "")
    $call  .= "ActionID: $actionid\r\n";
  $call  .= "\r\n";

  echo "<pre>";
  echo $call;
  echo "</pre>";

  include('login.php');

  fputs($socket, $action);
  fputs($socket, $call);
  fputs($socket, "Action: Logoff\r\n\r\n");

  $w = "";

  while (!feof($socket)) {
    $w .= fread($socket, 8192);
  }
  fclose($socket);

  echo "<pre>";
  echo <<<ASTERISKMANAGEREND
  $w
ASTERISKMANAGEREND;
  echo "</pre>";
  exit();
?>
