<?php
/* 
 Copyright (C) 2005-2007 Earl C. Terwilliger
 Email contact: earl@micpc.com

 Name : tc.php
 Usage: interface to traffic control functions for Linux

    This file is part of The Asterisk WEB/PHP Management Interface.

    These files are free software; you can redistribute them and/or modify
    them under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    These programs are distributed in the hope that they will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with these files (see COPYING); if not, write to the:

         Free Software Foundation, Inc.
         59 Temple Place
         Suite 330
         Boston, MA  02111-1307
         USA
*/

include('header.php');
include('files.php');
include('functions.php');

if (isset($_POST['submit'])) {
  $function  = $_POST['function'];
  if ($function == "add") {
    $dev      = $_POST['dev'];
    $ceil     = $_POST['ceil'];
    $rate     = $_POST['rate'];
    $halfrate = $_POST['halfrate'];
    $bulk     = $_POST['bulk'];
    $police   = $_POST['police'];
    echo "<PRE>\n";
    echo "Turning On the TC rules for $dev ...<br>\n";
    tcontrol($dev,$ceil,$rate,$halfrate,$bulk,$police);
    echo "<br>Complete.<br>\n";
    echo "</PRE>\n";
    flush();
    exit();
  }
  if ($function == "delete") {
    $dev = $_POST['dev'];
    if ($dev == "") {
      echo "<PRE>\n";
      echo "No device specified for turning Off the TC rules ...<br>\n";
      echo "</PRE>\n";
      exit();
    }
    echo "<PRE>\n";
    echo "Turning Off the TC rules for $dev ...<br>\n";
    myexec("/sbin/tc qdisc del dev $dev ingress");
    myexec("/sbin/tc qdisc del root dev $dev");
    flush();
    echo "<br>Complete.<br>\n";
    flush();
    echo "</PRE>\n";
    exit();
  }
  if ($function == "list") {
    $dev = $_POST['dev'];
    if ($dev == "") {
      echo "<PRE>\n";
      echo "No device specified for listing the TC rules ...<br>\n";
      echo "</PRE>\n";
      exit();
    }
    $command = "/sbin/tc -s qdisc show dev $dev";
    if (!($p=popen("($command)2>&1","r"))) {
      echo "<PRE>\n";
      echo "An error occurred running the command: $command<br>\n"; 
      echo "</PRE>\n";
      flush();
      exit();
    }
    echo "<CENTER>";
    echo "<H2> tc -s qdisc show dev $dev </H2>";
    echo "</CENTER>";
    echo "<PRE>\n";
    while (!feof($p)) {
      $l=fgets($p,256);
      $l = trim($l);
      echo $l;
      echo "<br>";
    }
    pclose($p);
    echo "</PRE>\n";
    $command = "/sbin/tc -s class show dev $dev";
    if (!($p=popen("($command)2>&1","r"))) {
      echo "<PRE>\n";
      echo "An error occurred runing the command: $command <br>\n"; 
      echo "</PRE>\n";
      flush();
      exit();
    }
    echo "<br>";
    echo "<CENTER>";
    echo "<H2> tc -s class show dev $dev </H2>";
    echo "</CENTER>";
    echo "<PRE>\n";
    while (!feof($p)) {
      $l=fgets($p,256);
      $l = trim($l);
      echo $l;
      echo "<br>";
    }
    pclose($p);
    echo "</PRE>\n";
    flush();
    exit();
  }
  echo "<PRE>\n";
  echo "Nothing to do?<br>\n"; 
  echo "</PRE>\n";
  flush();
  exit();
}
else {
?>
<H1>TRAFFIC CONTROL [TC] COMMANDS FOR ASTERISK</H1>
<center>
<form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="post">
<table border=0>
 <tr>
  <td colspan=2>
    <input type=radio name="function" value="delete">&nbsp;Delete
    <input type=radio name="function" value="add">&nbsp;Add
    <input type=radio name="function" value="list" checked>&nbsp;List
  </td>
 </tr>
 <tr>
  <td><input type=text  name="dev" value="eth0"></td>
  <td>Device</td>
 </tr>
 <tr>
  <td><input type=text  name="ceil" value="1Mbit"></td>
  <td>Ceiling [Maximum bandwidth] </td>
 </tr>
 <tr>
  <td><input type=text  name="rate" value=".9Mbit"></td>
  <td>Rate for VOIP [Highest bandwidth]</td>
 </tr>
 <tr>
  <td><input type=text  name="halfrate" value="512kbit"></td>
  <td>Rate for other Non-VOIP Traffic</td>
 </tr>
 <tr>
  <td><input type=text  name="bulk" value="256kbit"></td>
  <td>Rate for Bulk Traffic</td>
 </tr>
 <tr>
  <td><input type=text  name="police" value="512kbit"></td>
  <td>Rate for Ingress filtering [Police Rate]</td>
 </tr>
</table>
<input type="submit" name="submit" value="Submit">&nbsp;&nbsp;
<input type="reset"  value="Reset">
</form>
<p>
Note: Specify the device as eth0, eth1, etc.<br>Specify the ceiling and rates as a number and the quantifier Mbit or kbit. Examples: 256kbit 5Mbit<br>
</p>
</center>
<?php } ?>
